from continuousEngine import *
import math

debug = False

outr = 3
midl = 0.5
sides = 21

a = 1.9
b = 0.9
r = 0.5
s = 0.1
o = 0.25
w = 4
d = 2.8
h = 0.4

puzzles = [

([
((208.78394, 22.805357), 4, 9.7232141),
((75.962852, 190.28369), 1, 9.7232141),
((70.13488, 14.544704), 3, 9.7232141),
((229.70482, 193.88222), 6, 9.7232141),
((25.427435, 83.127441), 2, 9.7232141),
((264.00214, 91.68309), 1, 9.7232141)
],[
(6, [(84.802055,41.950096),(110.30336,41.950096),(110.30336,67.451397),(84.802055,67.451397)]),
(6, [(158.3172,64.002655),(183.8185,64.002655),(183.8185,89.503956),(158.3172,89.503956)]),
(3, [(108.97075,111.0654),(134.47205,111.0654),(134.47205,136.5667),(108.97075,136.5667)]),
(2, [(181.35477,134.97008),(206.85607,134.97008),(206.85607,160.47138),(181.35477,160.47138)])
]),

([
((208.78394, 22.805357), 4, 9.7232141),
((75.962852, 190.28369), 1, 9.7232141),
((70.13488, 14.544704), 3, 9.7232141),
((229.70482, 193.88222), 6, 9.7232141),
((25.427435, 83.127441), 4, 9.7232141),
((264.00214, 91.68309), 1, 9.7232141)
],[
(9, [(84.802055,41.950096),(110.30336,41.950096),(110.30336,67.451397),(84.802055,67.451397)]),
(8, [(158.3172,64.002655),(183.8185,64.002655),(183.8185,89.503956),(158.3172,89.503956)]),
(1, [(108.97075,111.0654),(134.47205,111.0654),(134.47205,136.5667),(108.97075,136.5667)]),
(1, [(181.35477,134.97008),(206.85607,134.97008),(206.85607,160.47138),(181.35477,160.47138)])
]),

([
((99.176788, 18.916071), 1, 9.7232141),
((66.062859, 166.24083), 3, 9.7232141),
((229.70482, 173.0215), 4, 9.7232141),
((202.83427, 23.443802), 1, 9.7232141)
],[
(3, [(143.82077,51.627656),(169.32207,51.627656),(169.32207,77.128957),(143.82077,77.128957)]),
(4, [(98.010035,108.94397),(123.51133,108.94397),(123.51133,134.44527),(98.010035,134.44527)]),
(2, [(158.72621,125.7772),(184.22751,125.7772),(184.22751,151.2785),(158.72621,151.2785)])
]),

([
((99.176788, 18.916071), 1, 9.7232141),
((66.062859, 166.24083), 3, 9.7232141),
((229.70482, 173.0215), 4, 9.7232141),
((202.83427, 23.443802), 1, 9.7232141)
],[
(4, [(143.82077,51.627656),(169.32207,51.627656),(169.32207,77.128957),(143.82077,77.128957)]),
(3, [(98.010035,108.94397),(123.51133,108.94397),(123.51133,134.44527),(98.010035,134.44527)]),
(2, [(158.72621,125.7772),(184.22751,125.7772),(184.22751,151.2785),(158.72621,151.2785)])
]),

([
((39.069645, 97.408928), 1, 9.7232141),
((225.70839, 54.86137), 0, 9.7232141),
((279.84381, 54.416428), 0, 9.7232141),
((290.85071, 98.720589), 0, 9.7232141),
((252.88339, 54.176544), 0, 9.7232141),
((23.371191, 55.489059), 0, 9.7232141),
((88.612877, 53.868652), 0, 9.7232141),
((168.81285, 54.975189), 0, 9.7232141),
((197.31078, 54.774021), 0, 9.7232141),
((55.114944, 54.062103), 0, 9.7232141),
((225.77357, 141.58517), 0, 9.7232141),
((279.90897, 141.14024), 0, 9.7232141),
((252.94858, 140.90036), 0, 9.7232141),
((23.436369, 142.21288), 0, 9.7232141),
((88.678055, 140.59247), 0, 9.7232141),
((168.87804, 141.69901), 0, 9.7232141),
((197.37596, 141.49783), 0, 9.7232141),
((55.180119, 140.78592), 0, 9.7232141)
],[
(1, [(236.88814,85.916334),(262.38944,85.916334),(262.38944,111.41763),(236.88814,111.41763)]),
(0, [(118.43862,42.1825),(143.93991,42.1825),(143.93991,67.6838),(118.43862,67.6838)]),
(0, [(118.5038,128.90631),(144.00509,128.90631),(144.00509,154.40761),(118.5038,154.40761)])
]),

([
((241.31653, 11.964533), 0, 9.7232141),
((45.974617, 44.12571), 1, 9.7232141),
((340.30621, 66.430351), 0, 9.7232141)
],[
(0, [(142.09448,90.723098),(167.59577,90.723098),(167.59577,116.2244),(142.09448,116.2244)]),
(1, [(239.54808,86.202872),(265.04937,86.202872),(265.04937,111.70417),(239.54808,111.70417)]),
(0, [(94.45958,157.95953),(119.96087,157.95953),(119.96087,183.46083),(94.45958,183.46083)])
]),

([
((21.726812, 141.82262), 0, 9.7232141),
((279.85657, 140.66293), 1, 9.7232141),
((279.77936, 165.69188), 0, 9.7232141),
((21.395716, 88.547302), 0, 9.7232141)
],[
(0, [(95.434735,101.93803),(120.93603,101.93803),(120.93603,127.43934),(95.434735,127.43934)]),
(0, [(138.25565,102.33331),(163.75694,102.33331),(163.75694,127.83461),(138.25565,127.83461)]),
(0, [(181.07656,102.22285),(206.57785,102.22285),(206.57785,127.72415),(181.07656,127.72415)]),
(0, [(223.89747,101.93169),(249.39876,101.93169),(249.39876,127.43299),(223.89747,127.43299)]),
(0, [(266.71838,102.1905),(292.21967,102.1905),(292.21967,127.6918),(266.71838,127.6918)]),
(1, [(9.792917,102.1325),(35.294207,102.1325),(35.294207,127.6338),(9.792917,127.6338)])
]),

([
((258.58099, 57.669071), 6, 9.7232141),
((172.38559, 57.669071), 4, 9.7232141),
((215.48329, 57.669071), 4, 9.7232141),
((129.28789, 57.669071), 2, 9.7232141)
],[
(0, [(95.434735,102.1905),(120.93603,102.1905),(120.93603,127.69181),(95.434735,127.69181)]),
(2, [(138.25565,102.1905),(163.75694,102.1905),(163.75694,127.6918),(138.25565,127.6918)]),
(4, [(181.07656,102.1905),(206.57785,102.1905),(206.57785,127.6918),(181.07656,127.6918)]),
(0, [(223.89747,102.1905),(249.39876,102.1905),(249.39876,127.6918),(223.89747,127.6918)]),
(6, [(266.71838,102.1905),(292.21967,102.1905),(292.21967,127.6918),(266.71838,127.6918)])
]),

([
((258.58099, 57.669071), 6, 9.7232141),
((172.38559, 57.669071), 5, 9.7232141),
((215.48329, 57.669071), 10, 9.7232141),
((129.28789, 57.669071), 3, 9.7232141)
],[
(4, [(95.434735,102.1905),(120.93603,102.1905),(120.93603,127.69181),(95.434735,127.69181)]),
(9, [(138.25565,102.1905),(163.75694,102.1905),(163.75694,127.6918),(138.25565,127.6918)]),
(0, [(181.07656,102.1905),(206.57785,102.1905),(206.57785,127.6918),(181.07656,127.6918)]),
(3, [(223.89747,102.1905),(249.39876,102.1905),(249.39876,127.6918),(223.89747,127.6918)]),
(0, [(266.71838,102.1905),(292.21967,102.1905),(292.21967,127.6918),(266.71838,127.6918)])
]),

([
((235.19565, 99.526207), 9, 9.7232141),
((235.19565, 76.642769), 9, 9.7232141),
((235.19565, 122.40965), 9, 9.7232141),
((235.19565, 145.29309), 9, 9.7232141)
],[
(12, [(100.12764,86.184795),(152.12068,86.184795),(152.12068,138.17785),(100.12764,138.17785)]),
(9, [(178.00785,178.35282),(73.135004,178.35282),(94.868514,149.3748),(153.51452,149.3748)]),
(7.5, [(58.995968,164.22783),(58.995968,59.354983),(87.973988,81.088493),(87.973988,139.7345)]),
(3, [(72.536028,46.257552),(177.40886,46.257552),(155.67535,75.235566),(97.029359,75.235566)]),
(0, [(195.68761,57.967701),(195.68761,162.84055),(166.70959,141.10704),(166.70959,82.461031)])
]),

([
((230.92761, 87.291214), 2, 9.7232141),
((217.26993, 58.148006), 3, 17.405649),
((239.60594, 105.1953), 1, 4.174788)
],[
(2, [(156.84322,89.020224),(132.15625,131.77932),(107.46928,89.020214)]),
(2, [(157.06534,72.691051),(107.69139,72.691054),(132.37837,29.931962)]),
(1, [(116.79865,138.90467),(67.424701,138.90467),(92.111681,96.145575)]),
(1, [(196.93776,139.7854),(147.56381,139.7854),(172.25079,97.026314)])
]),

([
    ((6,-1.1), 6, 1),
    ((6,1.1), 6, 1)
],[
    ((0.3 if i == 3 else 1 if i == 13 else 0),
     [
        (outr*math.cos(math.pi*2/sides*(i+0.1)), outr*math.sin(math.pi*2/sides*(i+0.1))),
        (outr*math.cos(math.pi*2/sides*(i+0.9)), outr*math.sin(math.pi*2/sides*(i+0.9))),
        (midl*math.cos(math.pi*2/sides*(i+0.5)), midl*math.sin(math.pi*2/sides*(i+0.5))),
    ])
    for i in range(sides)
]),

(
    [ ((a, b), 1, r)
    , ((b, -a), 2, r)
    , ((-a, -b), 3, r)
    , ((-b, a), 4, r)
    , ((b, b), 5, r)
    , ((b, -b), 6, r)
    , ((-b, -b), 7, r)
    , ((-b, b), 8, r)
    # , ((a, b), 5, r)
    # , ((a, b), 6, r)
    # , ((a, b), 7, r)
    # , ((a, b), 8, r)
    ],
    [ (1, [(-s, o-s), (s, o-s), (s, o+s), (-s, o+s)])
    , (2, [(o-s, -s), (o-s, s), (o+s, s), (o+s, -s)])
    , (3, [(-s, -o-s), (s, -o-s), (s, -o+s), (-s, -o+s)])
    , (4, [(-o-s, -s), (-o-s, s), (-o+s, s), (-o+s, -s)])
    , (0, [(-w, d), (-w, d+h), (w, d+h), (w, d)])
    , (0, [(-w, -d-h), (-w, -d), (w, -d), (w, -d-h)])
    ]
),

]


def realize_puzzle(puzzle):
    return ([(Point(*s), val, r) for (s, val, r) in puzzle[0]], [(val, (newps := (lambda pts: list(reversed(pts)) if polygon_area(pts) > 0 else pts)([Point(*p) for p in ps])), (lambda a,b:a%b)(*bounding_box(newps))) for (val, ps) in puzzle[1]])

class Layers:
    REGION = 1
    BALL = 2
    WIN = 3
class Colors:
    BALL = (60,60,60)
    BALLHELD = (110,110,110)
    BALLVAL = (255, 255, 255)
    EDGE = (0,0,0)
    REGION = (200, 200, 240)
    REGIONSAT = (200, 240, 200)
    REGIONVAL = (0,0,0)
    BGDEFAULT = (245,245,235)
    BGWIN = (120,245,120)
    TEXTWIN = (0,0,0)

class Ball(Renderable):
    def __init__(self, game, s, val, r, t):
        super().__init__(game, Layers.BALL)
        self.s, self.val, self.r, self.t = s, val, r, t
        self.held = False
        self.crocks = 0
    def render(self):
        drawSegment(self.game, Colors.EDGE, self.s, self.t)
        drawCircle(self.game, Colors.BALLHELD if self.held else Colors.BALL, self.t, self.r)
        if self.val: write(self.game.screen, self.game.font, str(self.val), *self.game.pixel(self.t), Colors.BALLVAL)

class Regions(Renderable):
    def __init__(self, game):
        super().__init__(game, Layers.REGION)
    def render(self):
        for ((val, poly, ctr), sat) in zip(self.game.regions, self.game.satisfied):
            drawPolygon(self.game, Colors.REGIONSAT if sat else Colors.REGION, poly)
            if val: write(self.game.screen, self.game.font, str(val), *self.game.pixel(ctr), Colors.REGIONVAL)

class Yosenabe(Game):
    def __init__(self, file=None, **kwargs):
        self.pidx = 0
        self.unlocked = 0
        self.load_puzzle()

        self.turn = 'solver'
        self.teams = [self.turn]

        super().__init__(name='della birth! :D', **kwargs)

        self.holding = None

        self.background = self.layers[-10**10][0]
        self.winning = False
        Regions(self)
        FixedText(self, Layers.WIN, Colors.TEXTWIN, self.font, (lambda: 'success! next level unlocked (use arrow keys to navigate)' if self.pidx < len(puzzles)-1 else 'that is all! happy birthday :))))'), 10, 10, halign='l', valign='t').GETvisible = lambda g: g.winning

        self.reset_state()
        if not self.headless: self.reset_view()

        def mousedown(e):
            pt = self.point(*e.pos)
            clicked_on = [b for b in self.layers[Layers.BALL] if pt>>b.t < b.r**2]
            if len(clicked_on) == 0: return
            if len(clicked_on) > 1: raise ValueError(f'overlapping pieces: {clicked_on}')
            b = clicked_on[0]
            b.held = True
            self.holding = (b, pt - b.t)

        def mousemove(e):
            if self.holding:
                pt = self.point(*e.pos)
                h = self.holding[0]
                tgt = pt - self.holding[1]
                for b in self.layers[Layers.BALL]:
                    if b is not h:
                        # test intersection of circles
                        if tgt>>b.t < (b.r+h.r)**2: break
                        # test intersection of lines
                        if intersect_segments(b.s, b.t, h.s, tgt): break
                        # test intersection of our circle with their line
                        if intersect_segment_disk(b.s, b.t, tgt, h.r): break
                        # test intersection of our line with their circle
                        if intersect_segment_disk(h.s, tgt, b.t, b.r): break
                else:
                    h.t = tgt

        def mouseup(e):
            if e.button != 1: return
            if self.holding:
                self.holding[0].held = False
                self.holding = None
            self.attemptMove({'player':self.turn})

        self.click[1] = mousedown
        self.drag[-1] = mousemove
        self.handlers[pygame.MOUSEBUTTONUP] = mouseup
        self.keyPress[pygame.K_LEFT] = lambda _: self.pidx > 0 and self.attemptMove({'player':self.turn,'pidx':self.pidx-1})
        self.keyPress[pygame.K_RIGHT] = lambda _: (self.pidx < self.unlocked or debug) and self.pidx < len(puzzles)-1 and self.attemptMove({'player':self.turn,'pidx':self.pidx+1})

        self.prep_turn()

    def load_puzzle(self):
        self.balls, self.regions = realize_puzzle(puzzles[self.pidx])
        self.satisfied = [False for _ in self.regions]

    def load_state(self, state):
        self.state = state
        self.clearLayer(Layers.BALL)
        for ball, pos in zip(self.balls, state): Ball(self, *ball, Point(*pos))

        p, q = bounding_box([p for b in self.layers[Layers.BALL] for p in [b.s, b.t]] + [p for (_, r, _) in self.regions for p in r])
        self.center = p%q
        self.spread = max((q-p).coords)/2 + 2 + max(b.r for b in self.layers[Layers.BALL])

    def save_state(self):
        return self.state

    def make_initial_state(self):
        return [b[0] for b in self.balls]

    def attemptGameMove(self, move):
        self.record_state()
        if 'pidx' in move:
            self.history = []
            self.future = []
            self.pidx = move['pidx']
            self.load_puzzle()
            self.reset_state()
            if not self.headless: self.reset_view()
        self.state = [b.t for b in self.layers[Layers.BALL]]
        return True

    def prep_turn(self):
        for b in self.layers[Layers.BALL]: b.crocks = 0
        pairs = [[b for b in self.layers[Layers.BALL] if intersect_circle_conv_polygon(b.t, b.r, poly) and not setattr(b, 'crocks', b.crocks+1)] for (_, poly, _) in self.regions]
        self.satisfied = [(lambda arr: abs(sum(arr) - val) < 0.0001 if val else len(arr) > 0)([b.val/b.crocks for b in balls]) for ((val, _, _), balls) in zip(self.regions, pairs)]
        self.winning = all(self.satisfied) and all(b.crocks for b in self.layers[Layers.BALL])
        if self.winning and self.unlocked < self.pidx+1: self.unlocked = self.pidx+1
        self.background.color = Colors.BGWIN if self.winning else Colors.BGDEFAULT


if __name__ == '__main__':
    pygame.init()
    run_local(Yosenabe, sys.argv[1:])
